<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('get-info', 'Api\ServiceController@info');
Route::post('get-token', 'Api\ServiceController@getToken');
Route::post('send-order', 'Api\ServiceController@addOrder');
Route::post('get-order-history', 'Api\ServiceController@getHistory');

Route::group(['prefix' => '/v1', 'namespace' => 'Api'], function() {
    Route::group(['prefix' => '/driver', 'namespace' => 'Driver'], function() {
        Route::post('/signin', 'AuthController@login'); 
        Route::group(['middleware' => 'auth:api-driver'], function() {
            Route::get('profile', 'ProfileController@profile');
            Route::post('profile-update', 'ProfileController@update');
            Route::get('orders', 'OrderController@index');
            Route::get('orders/show/{id}', 'OrderController@show');
            Route::post('orders/accept', 'OrderController@accept');
            Route::post('orders/refuse', 'OrderController@refuse');
            Route::post('orders/change-status', 'OrderController@changestatus');
        });
    });
    Route::group(['prefix' => '/company', 'namespace' => 'Company'], function() {
        Route::post('/signin', 'AuthController@login'); 
        Route::group(['middleware' => 'auth:api-company'], function() {
            Route::get('profile', 'ProfileController@profile');
            Route::post('profile-update', 'ProfileController@update');
            Route::get('notifications', 'ProfileController@notifications');
            Route::get('orders', 'OrderController@index');
            Route::get('orders/{id}', 'OrderController@show');
            Route::post('orders/store', 'OrderController@store');
            Route::get('invoices', 'OrderController@invoices');
            Route::get('transfers', 'OrderController@transfers');
            Route::get('statistics', 'OrderController@statistics');
        });
        Route::get('info', 'InfoController@index');

    });

    Route::get('/app-info', 'AppInfoController@index');
    Route::get('/get-statuses', 'AppInfoController@getStatuses');
    Route::post('/upload-file', 'HomeController@UploadFile');
});