<!DOCTYPE html>
<html lang="en" dir="rtl">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="description" content="A fully featured admin theme which can be used to build CRM, CMS, etc.">
        <meta name="author" content="Coderthemes">
        <meta name="csrf-token" content="{{csrf_token()}}">

        <!-- App Favicon -->
        <link rel="shortcut icon" href="{{ asset('/adminto/assets/images/favicon.ico')}}">

        <!-- App title -->
        <title> لوحه تحكم مدار </title>

        <!-- DataTables -->
        <link href="{{ asset('/adminto/assets/plugins/datatables/jquery.dataTables.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/plugins/datatables/buttons.bootstrap.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/plugins/datatables/fixedHeader.bootstrap.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/plugins/datatables/responsive.bootstrap.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/plugins/datatables/scroller.bootstrap.min.css')}}" rel="stylesheet" type="text/css" />

        <!-- App CSS -->
        <link href="{{ asset('/adminto/assets/css/bootstrap-rtl.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/core.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/components.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/icons.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/pages.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/menu.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/responsive.css')}}" rel="stylesheet" type="text/css" />

        <!-- HTML5 Shiv and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesnt work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->

        <script src="{{ asset('/adminto/assets/js/modernizr.min.js')}}"></script>

        <!-- cusotm style -->
        <link href="{{ asset('/adminto/assets/css/my-style.css')}}" rel="stylesheet" type="text/css" />

    </head>


    <body class="fixed-left">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Top Bar Start -->
            <div class="topbar">

                <!-- LOGO -->
                <div class="topbar-left">
                    <a href="{{url('/dashboard')}}" class="logo">
                        <img class="img-responsive" src="{{ asset('/adminto/assets/images/logo.png')}}">
                    </a>
                </div>
                <!--Navigation Menu-->
{{--  ////////////////////////////////////////////////////////////////////////////////////////////////////////  --}}
                    <div class="navbar navbar-default" role="navigation">
                        <div class="container">

<!-- Page title -->
<ul class="nav navbar-nav navbar-left">
    <li>
        <button class="button-menu-mobile  ">
            <i class="zmdi zmdi-menu"></i>
        </button>
    </li>
    <li>
        <h4 class="page-title">
             {{(isset($title))? $title : ''}} </h4>
    </li>
</ul>
<ul class="nav navbar-nav navbar-right">
                            @yield('header')
                            <li>
                                <!-- Notification -->
                                <div class="notification-box">
                                    <ul class="list-inline m-b-0">
                                        <li>
                                            <a href="javascript:void(0);" class="right-bar-toggle">
                                                <i class="zmdi zmdi-notifications-none"></i>
                                            </a>
                                            <div class="noti-dot">
                                                <span class="dot"></span>
                                                <span class="pulse"></span>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                            
                        </div><!-- end container -->
                    </div><!-- end navbar -->
                    {{--  ////////////////////////////////////////////////////////////////////////////////////////////////////////  --}}
            </div>
            <!-- Top Bar End -->


            @include('company.layout.sidebar')



            <!-- ============================================================== -->
            <!-- Start right Content here -->
            <!-- ============================================================== -->
            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container">


                       
                            @yield('content')
                     
                        <!-- end row -->




                    </div> <!-- container -->

                </div> <!-- content -->

                <footer class="footer">
                </footer>

            </div>


            <!-- ============================================================== -->
            <!-- End Right content here -->
            <!-- ============================================================== -->
            <!-- Right Sidebar -->
            <div class="side-bar right-bar">
                <a href="javascript:void(0);" class="right-bar-toggle">
                    <i class="zmdi zmdi-close-circle-o"></i>
                </a>
                <h4 class="">الاشعارات</h4>
                <div class="notification-list nicescroll">
                    <ul class="list-group list-no-border user-list" id="notifications">
                        @php
                        $user = auth('company')->user();
                        $notifications  = $user->unreadnotifications->sortByDesc('created_at');
                        @endphp             
                        @foreach($notifications as $item) 
                        <li class="list-group-item {{($item->read_at)? '' : 'active'}}">
                            @if( array_key_exists('redirect', $item->data) )
                            <a href="{{(str_contains($item->data['redirect'], '?'))? $item->data['redirect'].'&notify='.$item->id : $item->data['redirect'].'?notify='.$item->id}}" class="user-list-item">
                            @else
                            <a href="#" class="user-list-item">
                            @endif
                                <div class="avatar">
                                    <img src="" alt="">
                                </div>
                                <div class="user-desc" alt="{{$item->data['text']}}" title="{{$item->data['text']}}">
                                    <span class="desc">{{$item->data['text']}}</span>
                                    <span class="time">{{$item->created_at}}</span>
                                </div>
                            </a>
                        </li>
                        @endforeach

                    </ul>
                </div>
            </div>
            <!-- /Right-bar -->

        </div>
        <!-- END wrapper -->



        <script>
            var resizefunc = [];
        </script>

        <!-- jQuery  -->
        <script src="{{ asset('/adminto/assets/js/jquery.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/bootstrap-rtl.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/detect.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/fastclick.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/jquery.slimscroll.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/jquery.blockUI.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/waves.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/jquery.nicescroll.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/jquery.scrollTo.min.js')}}"></script>

        <!-- Datatables-->
        <script src="{{ asset('/adminto/assets/plugins/datatables/jquery.dataTables.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.bootstrap.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.buttons.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/buttons.bootstrap.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/jszip.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/pdfmake.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/vfs_fonts.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/buttons.html5.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/buttons.print.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.fixedHeader.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.keyTable.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.responsive.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/responsive.bootstrap.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.scroller.min.js')}}"></script>

        <!-- Datatable init js -->
        <script src="{{ asset('/adminto/assets/pages/datatables.init.js')}}"></script>

        <!-- App js -->
        <script src="{{ asset('/adminto/assets/js/jquery.core.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/jquery.app.js')}}"></script>

        <script type="text/javascript">
            $(document).ready(function() {
                $('#datatable').DataTable();
                $('#datatable-keytable').DataTable( { keys: true } );
                $('#datatable-responsive').DataTable();
                $('#datatable-scroller').DataTable( { ajax: "{{ asset('/adminto/assets/plugins/datatables/json/scroller-demo.json')}}", deferRender: true, scrollY: 380, scrollCollapse: true, scroller: true } );
                var table = $('#datatable-fixed-header').DataTable( { fixedHeader: true } );
            } );
            TableManageButtons.init();

        </script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

        <script>
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
        </script>
                <script>
        
                        $("#Customer_isOwner").on("click", function () {
                            var checked = $(this).is(':checked');
                            if (checked) {
                                $(".owner-inputs").removeClass('hidden');
                            } else {
                                $(".owner-inputs").addClass('hidden');
                            }
                        });
        
                        $("#Customer_isSc").on("click", function () {
                            var checked = $(this).is(':checked');
                            if (checked) {
                                $(".owner-sc").removeClass('hidden');
                            } else {
                                $(".owner-sc").addClass('hidden');
                            }
                        });
        
                        $('#bank-plus').on('click', function () {
                            if ($('.bank-plus').hasClass('hidden')) {
                                $('.bank-plus').removeClass('hidden');
                            } else {
                                $('.bank-plus').addClass('hidden');
                            }
                            return false;
                        });
        
                        $(".select2").select2();
        
                        
                    </script>
                    @if(session()->has('success'))
                    <script type="text/javascript">
                        
          
                        toastr["success"]("تمت العملية بنجاح .")
        
                        toastr.options = {
                          "closeButton": false,
                          "debug": false,
                          "newestOnTop": false,
                          "progressBar": false,
                          "positionClass": "toast-top-right",
                          "preventDuplicates": false,
                          "onclick": null,
                          "showDuration": "300",
                          "hideDuration": "1000",
                          "timeOut": "5000",
                          "extendedTimeOut": "1000",
                          "showEasing": "swing",
                          "hideEasing": "linear",
                          "showMethod": "fadeIn",
                          "hideMethod": "fadeOut"
                        }
                    </script>
                    @endif
                    @if(session()->has('warning'))
                    <script type="text/javascript">
                        
          
                        toastr["warning"]("{{session()->get('warning')}}")
        
                        toastr.options = {
                          "closeButton": false,
                          "debug": false,
                          "newestOnTop": false,
                          "progressBar": false,
                          "positionClass": "toast-top-right",
                          "preventDuplicates": false,
                          "onclick": null,
                          "showDuration": "500",
                          "hideDuration": "1000",
                          "timeOut": "5000",
                          "extendedTimeOut": "1000",
                          "showEasing": "swing",
                          "hideEasing": "linear",
                          "showMethod": "fadeIn",
                          "hideMethod": "fadeOut"
                        }
                    </script>
                    @endif
                     <script>
              var deleter = {
        
                  linkSelector : "a#delete-btn",
        
                  init: function() {
                      $(this.linkSelector).on('click', {self:this}, this.handleClick);
                  },
        
                  handleClick: function(event) {
                      event.preventDefault();
        
                      var self = event.data.self;
                      var link = $(this);
        
                      swal({
                          title: "هل أنت متأكد؟",
                          text: "أنك تريد حذف هذه المنطقه ؟",
                          icon: "warning",
                          buttons: true,
                          dangerMode: true,
                      }).then(function(isConfirm){
                          if(isConfirm){
                              var cr = $('meta[name="csrf-token"]').attr('content');
                              var o = link;
                              // alert(cr);
                              $(o).append('<i class="fa fa-spin fa-spinner"></i>');
                              $.post($(o).attr('href'),{
                                _token:cr,
                                _method:'DELETE'
                              },function(data){
                                $(o).find('i').remove();
                                $(o).append('<i class="fa fa-check"></i>');
                                setTimeout(function(){
                                  $(o).parent().parent().remove();
                                  if(typeof cb  == 'function'){
                                    cb();
                                  }
                                },1000);
                              });
                          }
                          else{
                              swal("تم الالغاء", "الحذف  الغي بنجاح");
                          }
                      });
        
                  },
              };
        
              deleter.init();
          </script>
          <script>
              var deleterfile = {
        
                  linkSelector : "a.delete-file",
        
                  init: function() {
                      $(this.linkSelector).on('click', {self:this}, this.handleClick);
                  },
        
                  handleClick: function(event) {
                      event.preventDefault();
        
                      var self = event.data.self;
                      var link = $(this);
        
                      swal({
                          title: "هل أنت متأكد؟",
                          text: "أنك تريد حذف هذه المنطقه ؟",
                          icon: "warning",
                          buttons: true,
                          dangerMode: true,
                      }).then(function(isConfirm){
                          if(isConfirm){
                              var cr = $('meta[name="csrf-token"]').attr('content');
                              var o = link;
                              // alert(cr);
                              $(o).append('<i class="fa fa-spin fa-spinner"></i>');
                              $.post($(o).attr('href'),{
                                _token:cr,
                                _method:'DELETE'
                              },function(data){
                                $(o).find('i').remove();
                                $(o).append('<i class="fa fa-check"></i>');
                                setTimeout(function(){
                                  $(o).parent().parent().remove();
                                  if(typeof cb  == 'function'){
                                    cb();
                                  }
                                },1000);
                              });
                          }
                          else{
                              swal("تم الالغاء", "الحذف  الغي بنجاح");
                          }
                      });
        
                  },
              };
        
              deleterfile.init();
          </script>
            <script>
                $(document).on('change', 'select[name=order_type]', function(){
                    var o = $(this);
                    $.get( "{{url('/ajax/drivers-by-type')}}" + "/" + $(this).val(), function( data ) {
                        o.closest('form').find('select[name=driver_id]').html(data).select2();
                    });
                });
                $(document).on('change', 'select[name=city_id]', function(){
                    var o = $(this);
                    $.get( "{{url('/regions')}}" + "/" + $(this).val(), function( data ) {
                        o.closest('form').find('select[name=region_id]').html(data);
                    });
                });
                $(document).on('change', 'select[name=region_id]', function(){
                    var o = $(this);
                    $.get( "{{url('/regions')}}" + "/" + $(this).val(), function( data ) {
                        o.closest('form').find('select[name=district_id]').html(data);
                    });
                });
            </script>
                
            <script src="{{ asset('/adminto/assets/plugins/mjolnic-bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js')}}"></script>
            <script src="{{ asset('/adminto/assets/plugins/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')}}"></script>
            <script>
            jQuery('.datepicker-input').datepicker();
            
            </script>
            
            <script>
                //    loader
                {{-- document.onreadystatechange = function () {
                  var state = document.readyState
                  if (state == 'interactive') {
                      document.getElementById('contents').style.visibility="hidden";
                  } else if (state == 'complete') {
                      setTimeout(function(){
                          document.getElementById('interactive');
                          document.getElementById('load').style.visibility="hidden";
                          document.getElementById('contents').style.visibility="visible";
                      },1000);
                  }
              } --}}
        
              $(document).on('click', '[type=submit]', function(){
                 // $(this).html('<i class="fa fa-spin fa-spinner"></i>');
                  // $(this).prop('disabled', true);
                  // return true;
              })
          </script>
                @yield('script')
    </body>
</html>