@extends('admin.layout.app')
@section('style')
<style>
    .text-muted {
        color: #000 !important;
    }
    .morris-hover.morris-default-style {
    position: absolute;
    }

</style>
@endsection
@section('content')

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-color panel-tabs panel-success">
            <div class="panel-heading panel-heading-custom">
                <ul class="nav nav-pills">
                    <li class="active">
                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                    </li>
                    <li class="">
                        <a href="#navpills-2" data-toggle="tab" aria-expanded="false">الطلبات</a>
                    </li>
                    <li class="">
                        <a href="#navpills-3" data-toggle="tab" aria-expanded="false">طلبات يجب تحصيلها</a>
                    </li>
                </ul>
            </div>
            <div class="panel-body">
                <div class="tab-content">
                    <div id="navpills-1" class="tab-pane fade in active">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-bordered table-striped text-center m-0">
                                    <thead>
                                        {{-- <tr>
                                            <th colspan="2" class="text-center">
                                                <img src=" {{ $driver->image }}" style="width: 100px; height: 100px;border-radius: 50%;border: 2px solid #2c0d0d;" />
                                            </th>
                                        </tr> --}}
                                        <tr>
                                            <th class="text-center" colspan="4">البيانات الأساسية</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>الاسم الاول</td>
                                            <td>{{$driver->first_name}}</td>
                                        </tr>
                                        <tr>
                                            <td>الاسم الاخير</td>
                                            <td>{{$driver->last_name}}</td>
                                        </tr>
                                        <tr>
                                            <td>البريد الالكتروني</td>
                                            <td>{{$driver->email}}</td>
                                        </tr>
                                        <tr>
                                            <td>رقم الجوال</td>
                                            <td>{{$driver->phone}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="col-md-6">
                                 <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="4">بيانات أخرى</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td> نوع السيارة</td>
                                                            <td>{{$driver->Car->name ?? ''}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td> المدينة </td>
                                                            <td>{{$driver->phone}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td> المنطقة</td>
                                                            <td>{{$driver->address}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td> الجنسية</td>
                                                            <td>{{$driver->nationality}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table> 
                            </div>
                            <div class="col-lg-6">
                                <div class="card-box">
                                    <h4 class="header-title m-t-0">التوصيل بالايام</h4>
                                    <div id="morris-bar-example" style="height: 280px;"></div>
                                </div>
                            </div><!-- end col -->
                            <div class="col-lg-6">
                                <div class="card-box">
                                    <h4 class="header-title m-t-0">التوصيل بالشهور</h4>
                                    <div id="morris-bar-example2" style="height: 280px;"></div>
                                </div>
                            </div><!-- end col -->
                        </div>
                    </div>
                    <div id="navpills-2" class="tab-pane fade">
                        <div class="row">
                            <div class="col-md-12">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        @php
                                            $i = 1;
                                        @endphp
                                        <tr>
                                          
                                            <th>
                                                #
                                            </th>
                                            {{--  <th>IDs </th>  --}}
                                            <th>  اسم المتجر </th>
                                            <th>   رقم تليفون المتجر </th>
                                            <th>  اسم المستلم </th>
                                            <th>    رقم الجوال</th>
                                            <th>   المدينه	   </th>
                                            <th>   العنوان بالتفصيل	   </th>
                                            <th>    عدد الطرود	   </th>
                                            <th>  السعر</th>
                                            <th>  طريقه الدفع </th>
                                            {{--  <th>   ملحوظات </th>  --}}
                                            <th>    الحالة </th>
                                            <th>    رقم المرجع </th>
                                            <th>  رقم التسلسل </th>
                                            <th>    تاريخ الانشاء</th>
                                            <th>    العمليات </th>
                                          

                                        </tr>
                                    </thead>

                                    <tbody>
                                        @foreach($driver->Order()->get() as $item)
                                        
                                        <tr>
                                            <td>
                                                {{$i++}}
                                            </td>
                                            <td>{{$item->Company->name ?? ''}} </td>
                                            <td>{{$item->Company->phone ?? ''}} </td>
                                            <td>{{$item->recipent_name}} </td>
                                            <td>{{$item->phone}} </td>
                                            <td> {{ $item->City->name ?? '' }}</td>
                                            <td>{{$item->adress_details}} </td>
                                            <td>{{$item->packages_number}} </td>
                                            <td>{{$item->price}}</td>
                                            <td>{{$item->PaymentMethod->name ?? '' }}</td>
                                               <td>
                                                    {!!Form::model($item , ['url' => ['/dashboard/orders/'.$item->id] , 'method'
                                                    => 'PATCH','files'=>true , 'class'=>'form']) !!}
                                                    {!! Form::select("status",OrderStatus($item->status),null,['class'=>"form-control select2", "autocomplete"=> 'off', "onchange" => "$(this).closest('form').submit()"])!!}
                                                    {!!Form::close() !!}
                                                </td>
                                            <td>{{$item->refrence_no}}</td>
                                            <td>{{$item->serial}}</td>
                                            <td>{{$item->created_at}}</td>

                                            
                                            <td class="btns">
                                                
                                                    <a href="/dashboard/orders/{{$item->id}}/edit" type="button" class="btn btn-info   waves-effect waves-light m-b-5 btn-xs"> <i class="fa fa-pencil"></i> تعديل </a>
                                                    <a href="{{route('orders.destroy',$item)}}" type="button" class="btn btn-danger delete-btn  waves-effect waves-light m-b-5 btn-xs"> <i class="fa fa-times"></i> حذف </a>
                                                    <a href="/dashboard/orders/{{$item->id}}" type="button"
                                                        class="btn btn-info   waves-effect waves-light m-b-5 btn-xs"> <i
                                                            class="fa fa-eye"></i> عرض </a>
                                                    <a href="/dashboard/order-bill/{{$item->id}}" type="button" class="btn btn-danger   waves-effect waves-light m-b-5 btn-xs"> <i class="fa fa-times"></i> طباعه بوليصه الشحن </a>
                                               
                                                </td>
                                                

                                        </tr>
                                        @endforeach
                                    

                                        
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div id="navpills-3" class="tab-pane fade">
                        <div class="row">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="card-box widget-user" style=" background-color: #ccc; ">
                                        <div class="text-center">
                                            <h2 class="text-info" data-plugin="counterup">{{$driver->Invoice()->where('orders.status', 'delivered')->where('orders.collected', 0)->sum('total_price')}} ر.س</h2>
                                            <h5> المبلغ الاجمالي</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card-box widget-user" style=" background-color: #ccc; ">
                                        <div class="text-center">
                                            <h2 class="text-info" data-plugin="counterup"> {{$driver->Invoice()->where('orders.status', 'delivered')->where('orders.collected', 0)->sum('total_price') - ($driver->Invoice()->where('orders.status', 'delivered')->where('orders.collected', 0)->count() * $driver->commission)}} ر.س</h2>
                                            <h5>المستحق للفرع   </h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card-box widget-user" style=" background-color: #ccc; ">
                                        <div class="text-center">
                                            <h2 class="text-info" data-plugin="counterup"> {{$driver->Invoice()->where('orders.status', 'delivered')->where('orders.collected', 0)->count() * $driver->commission}} ر.س</h2>
                                            <h5>المستحق للسائق</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        @php
                                            $i = 1;
                                        @endphp
                                        <tr>
                                          
                                            <th>
                                                #
                                            </th>
                                            {{--  <th>IDs </th>  --}}
                                            <th>  اسم المتجر </th>
                                            <th>   رقم تليفون المتجر </th>
                                            <th>  اسم المستلم </th>
                                            <th>    رقم الجوال</th>
                                            <th>   المدينه	   </th>
                                            <th>   العنوان بالتفصيل	   </th>
                                            <th>    عدد الطرود	   </th>
                                            <th>  السعر</th>
                                            <th>  طريقه الدفع </th>
                                            {{--  <th>   ملحوظات </th>  --}}
                                            <th>    الحالة </th>
                                            <th>    رقم المرجع </th>
                                            <th>  رقم التسلسل </th>
                                            <th>    تاريخ الانشاء</th>
                                            <th>    العمليات </th>
                                          

                                        </tr>
                                    </thead>

                                    <tbody>
                                        @foreach($driver->Order()->where('status', 'delivered')->where('collected', 0)->get() as $item)
                                        
                                        <tr>
                                            <td>
                                                {{$i++}}
                                            </td>
                                            <td>{{$item->Company->name ?? ''}} </td>
                                            <td>{{$item->Company->phone ?? ''}} </td>
                                            <td>{{$item->recipent_name}} </td>
                                            <td>{{$item->phone}} </td>
                                            <td> {{ $item->City->name ?? '' }}</td>
                                            <td>{{$item->adress_details}} </td>
                                            <td>{{$item->packages_number}} </td>
                                            <td>{{$item->price}}</td>
                                            <td>{{$item->PaymentMethod->name ?? '' }}</td>
                                            <td>
                                                {{__('words.'.$item->status)}}
                                            </td>
                                            <td>{{$item->refrence_no}}</td>
                                            <td>{{$item->serial}}</td>
                                            <td>{{$item->created_at}}</td>

                                            
                                            <td class="btns">
                                                    <a href="/dashboard/orders/{{$item->id}}" type="button"
                                                        class="btn btn-info   waves-effect waves-light m-b-5 btn-xs"> <i
                                                            class="fa fa-eye"></i> عرض </a>
                                                    <a href="/dashboard/order-bill/{{$item->id}}" type="button" class="btn btn-danger   waves-effect waves-light m-b-5 btn-xs"> <i class="fa fa-times"></i> طباعه بوليصه الشحن </a>
                                                </td>
                                                

                                        </tr>
                                        @endforeach
                                    

                                        
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- end col -->
    

</div>
<!-- end row -->

@endsection
@section('script')


<!--Morris Chart-->
<script src="/adminto/assets/plugins/morris/morris.min.js"></script>
<script src="/adminto/assets/plugins/raphael/raphael-min.js"></script>
<script type="text/javascript">
    // $('#datatable-0, #datatable-1, #datatable-2, #datatable-3, #datatable-4').DataTable( {
    //     "bLengthChange" : false, //thought this line could hide the LengthMenu
    //     "bInfo":false,  
    // } );
    
    // $('.buunton-notofication').on('click',function(){
    //     var type = $(this).data('type');     
    //     var message = $(this).data('message');     
    //     switch(type){
    //         case 'error' : toastr.error(message);  break;
    //         case 'success' : toastr.success(message);  break;
    //         case 'info' : toastr.info(message);  break;
    //         case 'warning' : toastr.warning(message);  break; 
    //     }
    //     return false;
    // });
    // TableManageButtons.init();

    $(document).on('click', '.client-info', function(){
        $.get( "{{url('/dashboard/user-info')}}" + "/" + $(this).attr('data-id'), function( data ) {
            $('#client-info-box').html(data);
        });
    });
    $(document).on('click', '.delete-btn', function(e){
        e.preventDefault();
        var link = $(this);
        swal({
            title: "هل أنت متأكد؟",
            text: "أنك تريد حذف هذه المنطقه ؟",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        }).then(function(isConfirm){
            if(isConfirm){
                var cr = $('meta[name="csrf-token"]').attr('content');
                var o = link;
                // alert(cr);
                $(o).append('<i class="fa fa-spin fa-spinner"></i>');
                $.post($(o).attr('href'),{
                  _token:cr,
                  _method:'DELETE'
                },function(data){
                  $(o).find('i').remove();
                  $(o).append('<i class="fa fa-check"></i>');
                  setTimeout(function(){
                    $(o).parent().parent().remove();
                    if(typeof cb  == 'function'){
                      cb();
                    }
                  },1000);
                });
            }
            else{
                swal("تم الالغاء", "الحذف  الغي بنجاح");
            }
        });
    });
//////////////////////////////////////// edit number of orders
    $("#merge_button").click(function(event){
        event.preventDefault();
        confirm('هل تريد تحديث المحدد؟');
        var status = $('#update-all').find('select[name=status]').val();
        var arr = [];
        var searchIDs = $(".ids:checkbox:checked").each(function(i){
            arr.push($(this).val() );
          return $(this).val();
        });
        console.log(arr);
        //post _token, arr
        // var jqxhr = $.post( "example.php", function() {
            // alert( "success" );
            // })  
        $.post( "{{route('orders-ajax')}}", { _token: "{{csrf_token()}}", ids: arr, status: status } )
            .done(function() {
                window.location.href = "{{route('orders.index')}}";
              alert( "تم التحديث بنجاح." );
            })
            .fail(function() {
              alert( "error" );
            })
            .always(function() {
            //   alert( "finished" );
            });
      });
         ///////////////////////////////////////////////////////////////

         $(".form").submit(function(e){
             // stop submit .. stop reloading page
             e.preventDefault();
            alert("هل تريد التحديث ؟");
            var data = $(this).serializeArray();
            console.log(data);
            $.post( $(this).attr('action'), data )
            .done(function() {
              alert( "تم التحديث بنجاح." );
              $(e.currentTarget).children('td, th').css('background-color','#000');
            })
            .fail(function() {
              alert( "error" );
            })
            .always(function() {
            });


          });
          //////////////////////////////////////////////////

          $("#checkAll").click(function(){
            $('input:checkbox').not(this).prop('checked', this.checked);
        });

      

  
</script>

<script>

    /**
    * Theme: Adminto Admin Template
    * Author: Coderthemes
    * Dashboard
    */
    
    !function($) {
        "use strict";
    
        var Dashboard1 = function() {
            this.$realData = []
        };
    
        //creates Bar chart
        Dashboard1.prototype.createBarChart  = function(element, data, xkey, ykeys, labels, lineColors) {
            Morris.Bar({
                element: element,
                data: data,
                xkey: xkey,
                ykeys: ykeys,
                labels: labels,
                hideHover: 'auto',
                resize: true, //defaulted to true
                gridLineColor: '#eeeeee',
                barSizeRatio: 0.2,
                barColors: lineColors
            });
        },
    
        //creates line chart
        Dashboard1.prototype.createLineChart = function(element, data, xkey, ykeys, labels, opacity, Pfillcolor, Pstockcolor, lineColors) {
            Morris.Line({
              element: element,
              data: data,
              xkey: xkey,
              ykeys: ykeys,
              labels: labels,
              fillOpacity: opacity,
              pointFillColors: Pfillcolor,
              pointStrokeColors: Pstockcolor,
              behaveLikeLine: true,
              gridLineColor: '#eef0f2',
              hideHover: 'auto',
              resize: true, //defaulted to true
              pointSize: 0,
              lineColors: lineColors
            });
        },
    
        //creates Donut chart
        Dashboard1.prototype.createDonutChart = function(element, data, colors) {
            Morris.Donut({
                element: element,
                data: data,
                resize: true, //defaulted to true
                colors: colors
            });
        },
        
        
        Dashboard1.prototype.init = function() {
    
            //creating bar chart
            var $barData  = JSON.parse('{!! $days_chart !!}');
            this.createBarChart('morris-bar-example', $barData, 'y', ['a'], ['العدد'], ['#188ae2']);
            //creating bar chart
            var $barData2  = JSON.parse('{!! $months_chart !!}');
            this.createBarChart('morris-bar-example2', $barData2, 'y', ['a'], ['عدد الطلبات'], ['#188ae2']);
    
        },
        //init
        $.Dashboard1 = new Dashboard1, $.Dashboard1.Constructor = Dashboard1
    }(window.jQuery),
    
    //initializing 
    function($) {
        "use strict";
        $.Dashboard1.init();
    }(window.jQuery);
    </script>
@endsection
