<?php
namespace App\Traits\Api;

use App\Http\Controllers\Api\FCMController;
use App\Notifications\GeneralNotification;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Driver;
use App\Models\PriceList;
use DB;
use Carbon\Carbon;
use App\Models\Admin;
use App\Notifications\AdminNotification;
use Auth;

trait OrderOperations
{
  

    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = $request->all();
        $data['company_id'] = Auth::guard('api-company')->user()->id;
        if ($request->hasFile('image')) {
            $data['image'] = uploadImage($request->file('image'));
        }
        if ($request->has('time')) {
            $data['time'] = Carbon::parse($request->get('time'));
        }
        if ($request->has('time_form')) {
            $data['time_form'] = Carbon::parse($request->get('time_form'));
        }
        if ($request->has('time_to')) {
            $data['time_to'] = Carbon::parse($request->get('time_to'));
        }
        if ($request->has('delivered_order')) {
            $data['delivered_order'] = Carbon::parse($request->get('delivered_order'));
        }
        ////////////////////////// serial start/////////////////////////////

        DB::beginTransaction();
        $Order = Order::create($data);
        $s = str_replace(' ', '',date('Y m').$Order->id);
        $serial = 'mx-'.$s;
        $Order->update(['serial' => $serial, 'serial_no' => (int)$s]);
        //////////////////////// the date of creation order
        $Order->OrderLog()->create([
            'status' => 'init',
            'details' =>  trans('words.'.'init')
        ]);
        $admin = Admin::first();
        $message = 'تم اضافة طلب جديد : '.$Order->id;
        if($admin)
        {
            $admin->notify(new GeneralNotification($message, '/dashboard/orders/'.$Order->id ) );
        }
        
        // if (in_array( auth('admin')->user()->role, ['branch', 'employee']) || (auth('admin')->user()->role == 'employee' && auth()->user()->parent_id != '0' )) {
        //     // 
        //     if (auth('admin')->user()->role == 'branch') {
        //         $branch_id = auth('admin')->id();
        //     } else {
        //         $branch_id = auth('admin')->user()->parent_id;
        //     }
        //     $Order->BranchData()->create(['admin_id' => $branch_id]);
        // }
        DB::commit();
        return $Order;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(Order $Order,$request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            @unlink(public_path('/cdn/'.$Order->image));
            // 
            $data['image'] = uploadImage($request->file('image'));
        }
        /////////////////////////////////////////////////////////// the date of first step from 
        if ($request->has('status') && $request->get('status') != 'init' && $request->get('status') != $Order->status) {
            $Order->OrderLog()->create([
                'status' => $request->get('status'),
                'details' =>  trans('words.'.$request->get('status')) . ' , ' . $request->get('notes')
            ]);
            $admin = Admin::first();
            $message = 'تم تغيير حالة الطلب  : '.$Order->id  . ' الي ' . trans('words.'.$request->get('status'));
            if($admin)
            {
                $admin->notify(new GeneralNotification($message, '/dashboard/orders/'.$Order->id ) );
            }
        }


        //make invoice if status=delivered
        if ($request->has('status') && in_array( $request->get('status') , ['delivered', 'returned'] ) && $request->get('status') != $Order->status) {
            if ($Order->city_id == $Order->Company->city_id) {
                $city_cost = $Order->Company->inside_price ?? 0;
            }else{
                $city_cost = $Order->Company->outside_price ?? 0;
            }
            $cost = 0;
            if ($Order->payment_method_id == '1') {
                $cost = 5;
            }
            if ($request->get('status') == 'returned') {
                $cost = 0;
                $city_cost = $Order->Company->return_cost ?? 0;
            }
            $madar_price = $city_cost + $cost;
            $total_price = $Order->price;
            $company_price = $Order->price - $madar_price;
            // here we will create invoice start
            $Order->Invoice()->create([
                'total_price'=>$total_price ,
                'company_price'=>$company_price ,
                'madar_price' => $madar_price ,
                'active' => 0,
            ]);
            // here we will create invoice end
        }
        $Order->update($data);
        return $Order;
    }
    /**
     * delete Record
     * @param $truck
     * @param $request
     */
    public function DeleteRecord($id)
    {
        //
    }
}
