<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    protected $table='cities';
    protected $fillable = [
        'name', 'parent'
    ];

    public function Parent()
    {
        return $this->belongsTo(City::class, 'parent');
    }

    public function Order()
    {
        return $this->Hasmany(Order::class, 'city_id');
    }
    public function BranchCity()
    {
        return $this->Hasmany(BranchCity::class, 'city_id');
    }

    public function Company()
    {
        return $this->Hasmany(Company::class, 'city_id');
    }
    public function DriverCity()
    {
        return $this->Hasmany(DriverCity::class, 'city_id');
    }
    public function Admin()
    {
        return $this->Hasmany(Admin::class, 'city_id');
    }
}
