<?php

namespace App\Imports;

use App\Models\Order;
use Maatwebsite\Excel\Concerns\ToModel;

class OrderImport implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        if($row[0] == '' || trim($row[0]) == 'اسم المستلم')
        {
            return null;
        }
        $Order =  Order::create([
            'recipent_name' => $row[0], 
            'phone' => $row[2], 
            'city_id'  => $row[4], 
            'adress_details'  => $row[1], 
            'packages_number'  => $row[6], 
            'price'   => $row[7], 
            'notes'  => $row[3], 
            'payment_method_id'  => $row[8], 
            'company_id'  => Request()->get('company_id'), 
            'status'  => 'init',
            'refrence_no' => $row[5], 

        ]);
        $s = str_replace(' ', '',date('Y m').$Order->id);
        $serial = 'mx-'.$s;
        $Order->OrderLog()->create([
            'status' => 'init',
            'details' =>  trans('words.'.'init')
        ]);
        $Order->update(['serial' => $serial, 'serial_no' => (int)$s]);
        return $Order;
    }
}
