<?php

namespace App\Http\Controllers\Api\Driver;

use App\Http\Requests\Api\UpdateDriverRequest;
use App\Http\Controllers\Controller;
use App\Traits\Api\DriverOperations;
use Illuminate\Http\Request;
use App\Models\Driver;
use Carbon\Carbon;
use Auth;
use Mail;
use Tymon\JWTAuth\Facades\JWTAuth;
use Validator;

class ProfileController extends Controller
{
    use DriverOperations;
    public function profile(Request $request)
    {
        $driver = Auth::guard('api-driver')->user();
        return Response()->json([
                'data' => [
                    'driver' => $driver
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function update(UpdateDriverRequest $request)
    {
        $driver = Auth::guard('api-driver')->user();
        
        $this->UpdateRecords($driver, $request);
        $driver = Driver::find($driver->id);
        $driver->token = auth('api-driver')->tokenById($driver->id);
        return Response()->json([
                'data' => [
                    'driver' => $driver
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function notifications(Request $request)
    {
        $user = auth('api-driver')->user();
        $notifications  = $user->unreadnotifications;
        if ($request->has('son_id') && $request->get('son_id') != '') {
            $son_id = $request->get('son_id');
            $notifications = $user->unreadnotifications()
                                ->where('data','LIKE','%"son":{"id":'.$son_id.'%')
                                // ->orWhere('data','LIKE','%"status":"0"%')
                                ->get();
        }
        // return $notifications;
        return Response()->json([
                'data' => [
                    'notifications' => $notifications
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
}
