<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateDriverRequest;
use App\Http\Requests\Admin\StoreDriverRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\DriverOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Driver;
use App\Models\Order;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class DriverController extends Controller
{
    use DriverOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('Permission:driver_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:driver_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:driver_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:driver_delete'  , ['only' => 'destroy']);
    }
    public function index(Request $request)
    {
        $title = 'السائقين ';
        ////////////////// branch or admin
        if (in_array( auth('admin')->user()->role, ['branch', 'employee']) || (auth('admin')->user()->role == 'employee' && auth()->user()->parent_id != '0' )) {
            // 
            if (auth('admin')->user()->role == 'branch') {
                $branch_id = auth('admin')->id();
            } else {
                $branch_id = auth('admin')->user()->parent_id;
            }
            $drivers = Driver::whereHas('BranchData', function($q)use($branch_id){
                $q->where('admin_id', $branch_id);
            })->latest();
        } else {
            $drivers = Driver::latest();
            
        }
        $search = array();
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $drivers = $drivers->where('id'     ,$id);
        }
        if (Request()->has('driver') && Request()->get('driver') != '') {
            $driver = Request()->get('driver');
            $search['driver'] = $driver;
            $drivers = $drivers->where('phone'     , 'LIKE', '%'.$driver.'%')->orWhere('name'     , 'LIKE', '%'.$driver.'%');
        }
        if (Request()->has('excel') && Request()->get('excel') != '') {
            $drivers = $drivers->get();
            return Excel::download(new GeneralExport('admin.reports.drivers-excel', $drivers), 'drivers-'.Carbon::now()->toDateString().'.xlsx');
        }
        $drivers = $drivers->paginate(40);
        return view('admin.drivers.index', compact('drivers','title', 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.drivers.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreDriverRequest $request)
    {
        $this->register($request);
        return redirect('/dashboard/drivers')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Driver $driver)
    {
        $title = 'عرض ';
        $months_chart = Order::where('driver_id', $driver->id)->whereDate('created_at', '>=', Carbon::now()->subMonths(6) )
                            ->whereDate('created_at', '<=', Carbon::now())
                            ->select( \DB::raw('COUNT(*) as a, DATE_FORMAT(created_at, "%Y-%m") as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get();
        $days_chart = Order::where('driver_id', $driver->id)->whereDate('created_at', '>=', Carbon::now()->subDays(15) )
                            ->whereDate('created_at', '<=', Carbon::now())
                            ->select( \DB::raw('COUNT(*) as a, DATE_FORMAT(created_at, "%Y-%m-%d") as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get();
        return view('admin.drivers.show', compact('driver', 'title', 'days_chart', 'months_chart'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $driver = Driver::find($id);
        $title = 'تعديل ';
        return view('admin.drivers.edit', compact('driver', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateDriverRequest $request, $id)
    {
      
        $driver = Driver::find($id);
        $this->UpdateRecords($driver, $request);
      
        return redirect('/dashboard/drivers')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // if ($driver->image) {
        //     @unlink(public_path('/cdn/'.$driver->image));
        // }
        $driver = Driver::find($id);
        $driver->delete();
        return 'success';
    }
    public function logout()
    {
        Auth::logout();
        return redirect('/login');
    }
}
